/*******************************************************
Filename		:  DW_user_def_hab.sql
Release 		:  1594, 1595
SIR			:  c2.0.3
Description		:  Creates dummy Characterisitic for user def hab assessments and associates
			   the appropriate records from the hab assessment result fact table.  Also
			   updates STATION_CHAR and the station_visited flag in FA_STATION.
Author			:  Joseph Wilson
Date			:  4/12/2004
			   4/14/2004 - changed characterisitic name as requested at 4/13 CCB -JW
			   5/05/2004 - changed bio and reg counts from 0 to NULL -JW
Comments		:  999999 is used as the dummy fk_char value.
**********************************************************/

spool DW_user_def_hab.log

-- create user def hab assessment characteristic
insert into di_characteristic 
	values (999999,'USER DEFINED HABITAT CHARACTERISTIC', 'User Defined Habitat Characteristic','H');

-- set fk_char for user def hab results
update fa_habitat_result set fk_char = 999999 where fk_char is null;

-- add entries with counts to station_char
insert into station_char
	select 999999,
		fk_station,
		'User Defined Habitat Characteristic',
		'USER DEFINED HABITAT CHARACTERISTIC',
		'H',
		NULL,
		NULL,
		count(pk_isn),
		min(activity_start_date_time),
		max(activity_start_date_time),
		count(pk_isn)
	from fa_habitat_result
	where fk_char = 999999
	group by fk_station; 

-- move station_visited logic or run the following:
update fa_station set station_visited = 'YES'
	where station_visited is null
	and pk_isn in (
		select fk_fa_statn from station_char
		where fk_char = 999999);
COMMIT;

SPOOL OFF;